<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AiChatController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\DashboardController;
use Illuminate\Support\Facades\Route;

// Default dashboard (Laravel Breeze)
Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])->name('dashboard');

// Role-based dashboards
Route::middleware(['auth'])->group(function () {
    Route::get('/doctor-dashboard', [DashboardController::class, 'doctorDashboard'])->name('doctor.dashboard');
    Route::get('/patient-dashboard', [DashboardController::class, 'patientDashboard'])->name('patient.dashboard');
    Route::get('/admin-dashboard', [DashboardController::class, 'adminDashboard'])->name('admin.dashboard');
    Route::get('/nurse-dashboard', [DashboardController::class, 'nurseDashboard'])->name('nurse.dashboard');
});

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';

// Auth Pages Routes (serve auth.blade.php layout)
Route::middleware('guest')->group(function () {
    Route::get('/login', function () {
        return view('auth');
    })->name('login');
    
    Route::get('/signup', function () {
        return view('auth');
    })->name('signup.page');
    
    Route::get('/register', function () {
        return view('auth');
    })->name('register.page');
    
    Route::get('/forgot-password', function () {
        return view('auth');
    })->name('forgot-password.page');
    
    // Traditional form-based login for session authentication
    Route::post('/login', [LoginController::class, 'webLogin'])->name('web.login');
});

// Logout route (accessible via URL)
Route::get('/logout', function() {
    \Illuminate\Support\Facades\Auth::logout();
    session()->invalidate();
    session()->regenerateToken();
    return redirect('/login')->with('message', 'You have been logged out successfully.');
})->middleware('auth')->name('web.logout');

// Catch-all route for Vue.js SPA - must be last
// Exclude dashboard routes, auth routes, and other Laravel Blade routes
Route::get('/{path?}', function () {
    return view('home');
})->where('path', '^(?!dashboard|doctor-dashboard|patient-dashboard|admin-dashboard|nurse-dashboard|login|signup|register|forgot-password|reset-password|verify-email|confirm-password|profile).*')->name('vue.app');
