<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <!--=========== Meta Tags ==========-->
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="author" content="Doctors Hero" />
    <meta name="description" content="Doctors Hero - EMR SaaS Platform with multi-role appointment management system" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />

    <!--============= Page title ============ -->
    <title>{{ config('app.name') }} - Find Your Trusted Doctors Today</title>

    <!--===== Favcion =====-->
    <link rel="shortcut icon" href="{{ asset('images/favicon.png') }}" />

    <!--===== Bootstrap min.css =====-->
    <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}" />

    <!--===== All Min Css =====-->
    <link rel="stylesheet" href="{{ asset('css/fontawesome.min.css') }}" />

    <!--===== Animate.css =====-->
    <link rel="stylesheet" href="{{ asset('css/animate.min.css') }}" />

    <!--===== Swiper Bundle.css =====-->
    <link rel="stylesheet" href="{{ asset('css/swiper-bundle.min.css') }}" />

    <!--===== Magnific Popup.css =====-->
    <link rel="stylesheet" href="{{ asset('css/magnific-popup.min.css') }}" />

    <!--===== Text Splitting.css =====-->
    <link rel="stylesheet" href="{{ asset('css/splitting.min.css') }}" />

    <!--<< MeanMenu.css >>-->
    <link rel="stylesheet" href="{{ asset('css/meanmenu.min.css') }}" />

    <!-- Flatpickr CSS -->
    <link rel="stylesheet" href="{{ asset('css/jquery-ui.min.css') }}" />

    <!--===== Main.css =====-->
    <link rel="stylesheet" href="{{ asset('css/style.css') }}" />
</head>

<body>
    <!-- Vue App Container -->
    <div id="app"></div>

    <!-- Scripts from Template -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <!--===== All JS Plugins =====-->
    <script src="{{ asset('js/jquery-3.7.1.min.js') }}"></script>
    <!--===== Bootstrap Js =====-->
    <script src="{{ asset('js/bootstrap.bundle.min.js') }}"></script>
    <!--===== Waypoints Js =====-->
    <script src="{{ asset('js/jquery.waypoints.min.js') }}"></script>
    <!--===== Counterup Js =====-->
    <script src="{{ asset('js/jquery.counterup.min.js') }}"></script>
    <!--===== Viewport Js =====-->
    <script src="{{ asset('js/viewport.jquery.min.js') }}"></script>
    <!--===== Tilt Js =====-->
    <script src="{{ asset('js/tilt.min.js') }}"></script>
    <!--===== Splitting Animation Js =====-->
    <script src="{{ asset('js/splitting.min.js') }}"></script>
    <!--===== Swiper Slider Js =====-->
    <script src="{{ asset('js/swiper-bundle.min.js') }}"></script>
    <!--===== Magnific Js =====-->
    <script src="{{ asset('js/magnific-popup.min.js') }}"></script>
    <!--===== Meanmenu Js =====-->
    <script src="{{ asset('js/jquery.meanmenu.min.js') }}"></script>
    <!--===== Wow Animation Js =====-->
    <script src="{{ asset('js/wow.min.js') }}"></script>
    <!-- Flatpickr JS -->
    <script src="{{ asset('js/jquery-ui.min.js') }}"></script>

    <!-- Gsap -->
    <script src="{{ asset('js/plugins/gsap.min.js') }}"></script>
    <script src="{{ asset('js/plugins/ScrollSmoother.min.js') }}"></script>
    <script src="{{ asset('js/plugins/ScrollToPlugin.min.js') }}"></script>
    <script src="{{ asset('js/plugins/ScrollTrigger.min.js') }}"></script>
    <script src="{{ asset('js/plugins/ScrollMagic.min.js') }}"></script>
    <script src="{{ asset('js/plugins/animation.gsap.min.js') }}"></script>
    <script src="{{ asset('js/plugins/ui-draggable.min.js') }}"></script>
    <script src="{{ asset('js/plugins/gsap-ease-pack.min.js') }}"></script>
    <script src="{{ asset('js/plugins/SplitText.min.js') }}"></script>
    <script src="{{ asset('js/gsap-comp/return-img-gsap.min.js') }}"></script>
    <script src="{{ asset('js/gsap-comp/pin-spacer.min.js') }}"></script>
    <script src="{{ asset('js/gsap-comp/gsap-split.min.js') }}"></script>
    <script src="{{ asset('js/gsap-comp/scroll-fixing.min.js') }}"></script>

    <!--===== Main.js =====-->
    <script src="{{ asset('js/main.js') }}"></script>

</body>

</html>