(function ($) {
  "use strict";
  var windowOn = $(window);
  gsap.registerPlugin(ScrollTrigger);
  let revealContainers = document.querySelectorAll(".return-left");
  revealContainers.forEach((container) => {
    let image = container.querySelector("img");
    let tl = gsap.timeline({
      scrollTrigger: {
        trigger: container,
        toggleActions: "restart none none reset",
      },
    });
    tl.set(container, { autoAlpha: 1 });
    tl.from(container, 1.5, { xPercent: -100, ease: Power2.out });
    if (image) {
      tl.from(image, 1.5, {
        xPercent: 100,
        scale: 1.3,
        delay: -1.5,
        ease: Power2.out,
      });
    }
  });
  let revealContainers2 = document.querySelectorAll(".return-right");
  revealContainers2.forEach((container) => {
    let image = container.querySelector("img");
    let tl = gsap.timeline({
      scrollTrigger: {
        trigger: container,
        toggleActions: "restart none none reset",
      },
    });
    tl.set(container, { autoAlpha: 1 });
    tl.from(container, 1.5, { xPercent: 100, ease: Power2.out });
    if (image) {
      tl.from(image, 1.5, {
        xPercent: 100,
        scale: 1.3,
        delay: -1.5,
        ease: Power2.out,
      });
    }
  });
  let revealContainersTop = document.querySelectorAll(".return-top");
  revealContainersTop.forEach((container) => {
    let image = container.querySelector("img");
    let tl = gsap.timeline({
      scrollTrigger: {
        trigger: container,
        toggleActions: "restart none none reset",
      },
    });
    tl.set(container, { autoAlpha: 1 });
    tl.from(container, 1.5, { yPercent: -100, ease: Power2.out });
    if (image) {
      tl.from(image, 1.5, {
        yPercent: 100,
        scale: 1.3,
        delay: -1.5,
        ease: Power2.out,
      });
    }
  });
  let revealContainersBottom = document.querySelectorAll(".return-bottom");
  revealContainersBottom.forEach((container) => {
    let image = container.querySelector("img");
    let tl = gsap.timeline({
      scrollTrigger: {
        trigger: container,
        toggleActions: "restart none none reset",
      },
    });
    tl.set(container, { autoAlpha: 1 });
    tl.from(container, 1.5, { yPercent: 100, ease: Power2.out });
    tl.from(image, 1.5, {
      yPercent: -100,
      scale: 1.3,
      delay: -1.5,
      ease: Power2.out,
    });
  });
  let revealContainersFooter = document.querySelectorAll(".return-footer");
  revealContainersFooter.forEach((container) => {
    gsap.from(container, {
      scrollTrigger: {
        trigger: container,
        start: "top 90%",
        toggleActions: "play none none reset",
      },
      opacity: 0,
      y: 40,
      duration: 1.2,
      ease: "power2.out",
    });
  });
})(jQuery);
