<?php

return [

    /*
    |--------------------------------------------------------------------------
    | AI Configuration
    |--------------------------------------------------------------------------
    |
    | Configure AI providers for D-Hero AI chatbot functionality
    |
    */

    /*
    |--------------------------------------------------------------------------
    | Primary AI Provider: DeepSeek
    |--------------------------------------------------------------------------
    */
    'use_deepseek' => env('AI_USE_DEEPSEEK', true),
    
    'deepseek' => [
        'api_key' => env('DEEPSEEK_API_KEY', 'sk-8d5c32bb4f054970aa5214ba311e4869'),
        'model' => env('DEEPSEEK_MODEL', 'deepseek-chat'),
        'base_url' => 'https://api.deepseek.com',
    ],

    /*
    |--------------------------------------------------------------------------
    | Alternative AI Provider: OpenAI (Commented out by default)
    |--------------------------------------------------------------------------
    | Uncomment and configure when you want to switch to OpenAI
    */
    // 'use_openai' => env('AI_USE_OPENAI', false),
    
    // 'openai' => [
    //     'api_key' => env('OPENAI_API_KEY', ''),
    //     'model' => env('OPENAI_MODEL', 'gpt-3.5-turbo'),
    //     'base_url' => 'https://api.openai.com/v1',
    // ],

    /*
    |--------------------------------------------------------------------------
    | Chat Configuration
    |--------------------------------------------------------------------------
    */
    'max_message_length' => 1000,
    'max_tokens' => 500,
    'temperature' => 0.7,
    'timeout' => 30,

];